using System;
using System.Drawing;
using System.Text;
using System.IO;
using System.ComponentModel.Design;
using System.Collections.Specialized;
using System.Windows.Forms;
using System.Reflection;

using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.Handles;
using Borland.Eco.Handles.Design;
using Borland.Eco.Persistence.Design;
using Borland.Eco.Persistence;

namespace Borland.Eco.Examples.EcoSpaceDesignerPlugins
{
	/// <summary>
	/// GenerateAndValidate implements IEcoSpaceDesignerTool by inheritance
	/// </summary>
	
	[ToolboxBitmap(typeof(GenerateAndValidate), "Borland.Eco.Examples.EcoSpaceDesignerPlugins.GenerateAndValidate.bmp")]
	public class GenerateAndValidate: DBToolBase
	{
		private static ValidateModelTool validateModelTool;
		private static GenerateDBTool generateDBTool;
		/// <summary>
		/// Registration method, called automatically by the IDE
		/// required to register the tool.
		///
		/// Create a new instance of the tool and make it known to the registry of tools.
		/// </summary>
		public static void IDERegister()
		{
			for (int i = EcoSpaceDesignerToolbox.Count - 1; i > -1 ; i--)
			{
				if (EcoSpaceDesignerToolbox.Tool(i) is GenerateDBTool)
				{
					generateDBTool = EcoSpaceDesignerToolbox.Tool(i) as GenerateDBTool;
					EcoSpaceDesignerToolbox.RemoveToolAt(i);
				}
				if (EcoSpaceDesignerToolbox.Tool(i) is ValidateModelTool)
				{
					validateModelTool = EcoSpaceDesignerToolbox.Tool(i) as ValidateModelTool;
				}
			}
			EcoSpaceDesignerToolbox.AddTool(new GenerateAndValidate());
		}
		/// <summary>
		/// Implementation of IEcoSpaceDesignerTool.GetHint.
		/// This is the flyover hint for the tool
		/// </summary>
		public override string GetHint()
		{
			return "Validate model and generate schema";
		}
		/// <summary>
		/// Implementation of IEcoSpaceDesignerTool.Execute
		/// Execute is called when the GUI widget (button) is invoked.
		/// </summary>
		public override void Execute(ExecuteArgs executeArgs)
		{
			validateModelTool.Execute(executeArgs);
			bool modelIsValid =  validateModelTool.ValidationReport.Messages.Count == 0;
			if (!modelIsValid)
			{
				MessageHelper.AddMessage(PersistenceStringRes.sModelValidationCaption,
							 PersistenceStringRes.sModelErrors);
				foreach (string s2 in validateModelTool.ValidationReport.Messages)
					MessageHelper.AddMessage("	" + s2);

				if (System.Windows.Forms.MessageBox.Show(
						"Model failed to validate OK. Continue generate schema?",
						"Continue generation?",
						MessageBoxButtons.OKCancel,
						MessageBoxIcon.Warning) == DialogResult.OK)
				{
					generateDBTool.Execute(executeArgs);
				}
			}
			else
				generateDBTool.Execute(executeArgs);			
		}
	}
}